# Changelog - Metals API WordPress Plugin

## Versión 2.6 (Corrección de Errores Críticos)

### Problemas Corregidos:

1. **Interpretación Incorrecta de la Respuesta de la API**:
   - **Problema**: El plugin usaba `"XAU": 0.00029654264553187` en lugar de `"USDXAU": 3372.1962593489043`
   - **Solución**: Ahora usa el valor correcto `USDXAU` que representa el precio real del metal en USD

2. **Conversiones de Unidades Incorrectas**:
   - **Problema**: Los factores de conversión estaban multiplicando en lugar de convertir correctamente
   - **Solución**: 
     - Gramos: `$priced * 0.035274` (1 gramo = 0.035274 onzas)
     - Kilogramos: `$priced * 35.274` (1 kg = 35.274 onzas)
     - Onzas: Sin conversión (valor original)

3. **Debug Mejorado**:
   - **Problema**: El debug solo funcionaba con `?depurando=1`
   - **Solución**: Ahora funciona con `?debug=1` o `?depurando=1` y muestra información más detallada

### Cómo Usar el Debug:

Para diagnosticar problemas, agrega `debug="true"` al shortcode:

```php
[metals_api_price symbol="XAU" unit="gram" debug="true"]
```

El debug mostrará:
- Símbolo original y procesado
- URL de la petición a la API
- Respuesta completa de la API
- Precio original por onza
- Precio convertido según la unidad
- Unidad seleccionada

### Ejemplos de Uso Corregidos:

```php
// Oro en gramos
[metals_api_price symbol="gold" unit="gram" base="USD"]

// Plata en kilogramos  
[metals_api_price symbol="silver" unit="kg" base="USD"]

// Platino en onzas
[metals_api_price symbol="platinum" unit="ounce" base="USD"]
```

### Valores Esperados (Aproximados):

- **Oro**: ~$2,000/onza → ~$70.55/gramo
- **Plata**: ~$25/onza → ~$0.88/gramo  
- **Platino**: ~$1,000/onza → ~$35.27/gramo

### Notas Importantes:

1. Los precios de la API están en **onzas troy** por defecto
2. Las conversiones ahora son matemáticamente correctas
3. El debug ayuda a identificar problemas de configuración
4. El plugin ahora maneja correctamente tanto códigos (XAU, XAG) como nombres (gold, silver) 